
/* 11/15/08 VERSION*/


***** SET PATH NAME AS APPROPRIATE FOR YOUR COMPUTER;

libname rama 'C:\rama\FinalfilesforPRC';
libname temp 'C:\rama\FinalfilesforPRC\temp';

data temp.tempz;
        set rama.cityfy2007z; /* change path as per your computer*/
		* ccs.z= ccs.cityfy2007z*;
        posstops=1;
        posdelv=posbus+posres;
        totdelv=resdelv+busdelv;
        stops=(totdelv>0);
* A = volumes for Other Letters; 
* B = volumes for Flats;
* E= volumes for Small Parcels;
* F= volumes for Large Parcels;
* X= volumes for DPS Letters;
*changed from A,B,C (1999) to A,B,E,F,X (2007);
*introduced A56, B56- changed from 55 buckets (1999) to 56 buckets (2007);

proc summary data=temp.tempz;
        class testid;
        var A1 A2 A3 A4 A5 A6 A7 A8 A9 A10 A11 A12 A13 A14 A15 A16 A17 A18 A19 A20
        A21 A22 A23 A24 A25 A26 A27 A28 A29 A30 A31 A32 A33 A34 A35 A36 A37
        A38 A39 A40 A41 A42 A43 A44 A45 A46 A47 A48 A49 A50 A51 A52 A53 A54
        A55 A56 B1 B2 B3 B4 B5 B6 B7 B8 B9 B10 B11 B12 B13 B14 B15 B16 B17 B18
        B19 B20 B21 B22 B23 B24 B25 B26 B27 B28 B29 B30 B31 B32 B33 B34 B35
        B36 B37 B38 B39 B40 B41 B42 B43 B44 B45 B46 B47 B48 B49 B50 B51 B52
        B53 B54 B55 B56 E1 E2 E3 E4 E5 E6 E7 E8 E9 E10 E11 E12 E13 E14 E15
        E16 E17 E18 E19 E20 E21 E22 E23 E24 E25 E26 E27 E28 E29 E30 E31 E32
        E33 E34 E35 E36 E37 E38 E39 E40 E41 E42 E43 E44 E45 E46 E47 E48 E49
        E50 E51 E52 E53 E54 E55 E56 F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 F13 F14 F15
        F16 F17 F18 F19 F20 F21 F22 F23 F24 F25 F26 F27 F28 F29 F30 F31 F32
        F33 F34 F35 F36 F37 F38 F39 F40 F41 F42 F43 F44 F45 F46 F47 F48 F49
        F50 F51 F52 F53 F5	F55 F56 X1 X2 X3 X4 X5 X6 X7 X8 X9 X10 X11 X12 X13 X14 X15
        X16 X17 X18 X19 X20 X21 X22 X23 X24 X25 X26 X27 X28 X29 X30 X31 X32
        X33 X34 X35 X36 X37 X38 X39 X40 X41 X42 X43 X44 X45 X46 X47 X48 X49
        X50 X51 X52 X53 X54 X55 X56 BUSDELV RESDELV POSBUS POSRES totdelv posstops
        stops posdelv;
        output out=rama.routes sum=;
		* the obs without a testid= sum;
run;

data rlv (keep=CAG RCAT STRATUM TESTID WGT);
        set rama.cityfy2007z;

proc sort;
        by testid;

proc sort data=rama.routes;
        by testid;

data rama.routes;
        update rama.routes rlv;
        by testid;
		if testid = "." then delete; /*(deletes the sum row)*/
run;

data rama.routes;
        set rama.routes;
        a41=sum(a31,a32,a33,a34,a36,a37,a38,a39,a40);
        b41=sum(b31,b32,b33,b34,b36,b37,b38,b39,b40);
        e41=sum(e31,e32,e33,e34,e36,e37,e38,e39,e40);
        f41=sum(f31,f32,f33,f34,f36,f37,f38,f39,f40);
        x41=sum(x31,x32,x33,x34,x36,x37,x38,x39,x40);
DATA rama.routes;
   SET rama.routes;
   ARRAY A (I) A1-A56;
   ARRAY B (I) B1-B56;
   ARRAY E (I) E1-E56;
   ARRAY F (I) F1-F56;
   ARRAY X (I) X1-X56;
   ARRAY D (I) D1-D56;

 DO I=1 TO 56;
   IF A=. THEN A=0;
   IF B=. THEN B=0;
   IF E=. THEN E=0;
   IF F=. THEN F=0;
   IF X=. THEN X=0;

   D=A+B+E+F+X; *D= total shape volume;
   d16= d12+d14+d18; *Total ECR= D16= Standard ECR Saturation+ Stand ECR Other+ Nonprofit ECR;
   D17= D13+ D15; * Total Regular Standard= Standard EFM+ Standard NFM;
 END;
* changed from A,B,C (1999) to A,B,E,F,X (2007);
*introduced A56, B56- changed from 55 buckets (1999) to 56 buckets (2007);

data rama.routes (drop=I a1 a2 a3 a4 a5 a6 a7 a8 a9 a10 a11 a12 a13 a14 a15 a16 a17 a18 a19 a20
        a21 a22 a23 a24 a25 a26 a27 a28 a29 a30 a31 a32 a33 a34 a35 a36 a37
        a38 a39 a40 a41 a42 a43 a44 a45 a46 a47 a48 a49 a50 a51 a52 a53 a54
        a55 a56 b1 b2 b3 b4 b5 b6 b7 b8 b9 b10 b11 b12 b13 b14 b15 b16 b17 b18
        b19 b20 b21 b22 b23 b24 b25 b26 b27 b28 b29 b30 b31 b32 b33 b34 b35
        b36 b37 b38 b39 b40 b41 b42 b43 b44 b45 b46 b47 b48 b49 b50 b51 b52
        b53 b54 b55 b56 e1 e2 e3 e4 e5 e6 e7 e8 e9 e10 e11 e12 e13 e14 e15
        e16 e17 e18 e19 e20 e21 e22 e23 e24 e25 e26 e27 e28 e29 e30 e31 e32
        e33 e34 e35 e36 e37 e38 e39 e40 e41 e42 e43 e44 e45 e46 e47 e48 e49
        e50 e51 e52 e53 e54 e55 e56 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
        f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 f28 f29 f30 f31 f32
        f33 f34 f35 f36 f37 f38 f39 f40 f41 f42 f43 f44 f45 f46 f47 f48 f49
        f50 f51 f52 f53 f54 f55 f56 x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15
        x16 x17 x18 x19 x20 x21 x22 x23 x24 x25 x26 x27 x28 x29 x30 x31 x32
        x33 x34 x35 x36 x37 x38 x39 x40 x41 x42 x43 x44 x45 x46 x47 x48 x49
        x50 x51 x52 x53 x54 x55 x56 d1 d6 d9 d11 d12 d13 d14 d15 d18 d19 d20 d21 d22 d26 d27 d30 d31 d32
        d33 d34 d35 d36 d37 d38 d39 d40 d42 d43 d44 d45 d46 d47 d48 d49
        d50 d51 d52 d53 d54 d55 d56);
        set rama.routes;
* dropped also the unnecessary D;

*  The city data are sampled at each 10th stop. They are multiplied by 10 to obtain the volumes for the full route. 
In this way, they will match the rural data, which are calculated for the entire route.  All the other city variables-
revenue, variable costs, nondelivery costs will be for the full route, because they are based on
the volumes. Therefore, there is no need of additional multiplication with 10 when total revenue obtained;
totdelv=totdelv*10;
posdelv=posdelv*10;
	d2=d2*10;
    d3=d3*10;
    d4=d4*10;
    d5=d5*10;
    d7=d7*10;
    d8=d8*10;
    d10=d10*10;
    d16=d16*10;
    d17=d17*10;
    d23=d23*10;
    d24=d24*10;
    d25=d25*10;
    d28=d28*10;
    d29=d29*10;
    d41=d41*10;
volume= sum(d2,d3,d4,d5,d7,d8,d10,d16,d17,d23,d24,d25,d28,d29,d41);
run;

data rama.city0 (keep=testid 
d2 d3 d4 d5 d7 d8 d10 d16 d17 d23 d24 d25 d28 d29 d41 
rev2 rev3 rev4 rev5 rev7 rev8 rev10 rev16 rev17 rev23 rev24 rev25 rev28 rev29 rev41 
vdc2 vdc3 vdc4 vdc5 vdc7 vdc8 vdc10 vdc16 vdc17 vdc23 vdc24 vdc25 vdc28 vdc29 vdc41 
ndc2 ndc3 ndc4 ndc5 ndc7 ndc8 ndc10 ndc16 ndc17 ndc23 ndc24 ndc25 ndc28 ndc29 ndc41 
nondcost vardcost revenue busdelv cag posbus posres rcat resdelv stratum wgt 
delvcost profit totcost posstops totdelv posdelv stops volume 
fxddcost variblty);
     set rama.routes;


* unit revenue per route (Dollars/per piece) from Calculations 2007.xls, worksheet Revenue per piece, 
transformed in Matching_rural_city.xls worksheet buckets_URevenue;
* originally from "Calculation of Revenue and Non-Delivery Cost per piece by Subclass", 
* Docket No. ACR2007-1, Library Reference PRC-ACR2007-LR1, 07 Revenue_Fees_LR1.xls, Worksheet "All_R";

	 *calculated revenue per subclass and total revenue for full route;
        rev2=d2*0.49284;
        rev3=d3*0.33026;
        rev4=d4*0.26006;
        rev5=d5*0.19827;
        rev7=d7*5.83566;
        rev8=d8*17.35771;
        rev10=d10*0.24875;
        rev16= d16*0.17428;
        rev17= d17*0.21418;
        rev23=d23*3.46544;
        rev24=d24*1.08308;
        rev25=d25*2.30393;
        rev28=d28*0.00000;
        rev29=d29*0.00000;
        rev41=d41*2.44514;


        revenue=sum(rev2,rev3,rev4,rev5,rev7,rev8,rev10,rev16,rev17,
        rev23,rev24,rev25,rev28,rev29,rev41);

* unit variable delivery cost for city is unit delivery cost(dollars/piece/ per route). I used delivery cost
calculated as the sum of piggybacked unit delivery cost for city and piggybacked
unit delivery cost for rural;
* from Calculations_2007.xls, worksheet Non delivery unit attributable, transformed in
Matching_rural_city.xls worksheet buckets_Udeliverycost;

	*calculated variable delivery cost per subclass and total vdc for full route;

        vdc2=d2* 0.09002;
        vdc3=d3*0.04288;
        vdc4=d4*0.09644;
        vdc5=d5*0.03736;
        vdc7=d7*0.36529;
        vdc8=d8*1.4407;
        vdc10=d10*0.09306;
        vdc16=d16*0.06091;
        vdc17=d17*0.05515;
        vdc23=d23*0.47284;
        vdc24=d24*0.26043;
        vdc25=d25*0.36714;
        vdc28=d28*0.07572;
        vdc29=d29*0.18878;
        vdc41=d41*0.08501;

        vardcost=sum(vdc2,vdc3,vdc4,vdc5,vdc7,vdc8,vdc10,vdc16,vdc17,
        vdc23,vdc24,vdc25,vdc28,vdc29,vdc41);

* Unit Non delivery costs (dollars/piece/route). From Calculations 2007.xls, worksheet Revenue per piece
(also, worksheet Non delivery unit atrributable- in cents);

		*calculated ndc per subclass and total ndc for full route;

        ndc2=d2*0.21946;
        ndc3=d3*0.07532;
        ndc4=d4*0.14080;
        ndc5=d5*0.04026;
        ndc7=d7*4.16058;
        ndc8=d8*9.66578;
        ndc10=d10*0.20661;
        ndc16=d16*0.03058;
        ndc17=d17*0.08997;
        ndc23=d23*2.88022;
        ndc24=d24*0.68392;
        ndc25=d25*2.15427;
        ndc28=d28*0.40445;
        ndc29=d29*0.70417;
        ndc41=d41*2.05256;

        nondcost= sum(ndc2,ndc3,ndc4,ndc5,ndc7,ndc8,ndc10,ndc16,ndc17,
        ndc23,ndc24,ndc25,ndc28,ndc29,ndc41);

        if rcat=1 or rcat=2 then delvcost=494.45;
        else delvcost= 409.32;
		if delvcost lt vardcost then fxddcost=0;
		if delvcost ge vardcost then fxddcost= delvcost-vardcost;
		totcost = delvcost+nondcost;
		profit=revenue-totcost;
		variblty=vardcost/delvcost;

run;

proc sort data=rama.city0; 
	by testid;


data rama.city0;
	set rama.city0;

qtr = floor(testid/100000);  

If stratum = "SBSA2E" then do;
    if qtr =1 then rtwgt =  26.301887/4;
    if qtr = 2 then rtwgt = 31.173077/4;
    if qtr = 3 then rtwgt = 29.810811/4;
    if qtr = 4 then rtwgt = 30.619469/4;
end;

If stratum = "SBSF2L" then do;
    If  qtr = 1 then rtwgt = 7.200000/4;
    If  qtr = 2 then rtwgt = 11.250000/4;
    If  qtr = 3 then rtwgt = 7.666667/4;
    If  qtr = 4 then rtwgt = 9.000000/4;
end;

If stratum = "SRSA2E" then do;
    If qtr=1 then rtwgt = 80.307355/4;
    If qtr=2 then rtwgt = 81.564230/4;
    If qtr=3 then rtwgt = 81.046154/4;
    If qtr=4 then rtwgt = 81.260966/4;
  end;

If stratum = "SRSF2L" then do;
    If qtr=1 then rtwgt = 91.634483/4;
    If qtr=2 then rtwgt = 91.822695/4;
    If qtr=3 then rtwgt = 85.282895/4;
    If qtr=4 then rtwgt = 84.554140/4;
end;

run;


/*proc means data = rama.city0;
var d2 d3 d4 d5 d7 d8 d10 d16 d17 d23 d24 d25 d28 d29 d41 
rev2 rev3 rev4 rev5 rev7 rev8 rev10 rev16 rev17 rev23 rev24 rev25 rev28 rev29 rev41 
vdc2 vdc3 vdc4 vdc5 vdc7 vdc8 vdc10 vdc16 vdc17 vdc23 vdc24 vdc25 vdc28 vdc29 vdc41 
ndc2 ndc3 ndc4 ndc5 ndc7 ndc8 ndc10 ndc16 ndc17 ndc23 ndc24 ndc25 ndc28 ndc29 ndc41 
nondcost vardcost revenue busdelv posbus posres rcat resdelv wgt 
delvcost profit totcost posstops totdelv posdelv stops volume 
fxddcost variblty;

output out = totals mean = d2 d3 d4 d5 d7 d8 d10 d16 d17 d23 d24 d25 d28 d29 d41 
rev2 rev3 rev4 rev5 rev7 rev8 rev10 rev16 rev17 rev23 rev24 rev25 rev28 rev29 rev41 
vdc2 vdc3 vdc4 vdc5 vdc7 vdc8 vdc10 vdc16 vdc17 vdc23 vdc24 vdc25 vdc28 vdc29 vdc41 
ndc2 ndc3 ndc4 ndc5 ndc7 ndc8 ndc10 ndc16 ndc17 ndc23 ndc24 ndc25 ndc28 ndc29 ndc41 
nondcost vardcost revenue busdelv posbus posres rcat resdelv wgt 
delvcost profit totcost posstops totdelv posdelv stops volume 
fxddcost variblty
					sum = sd2 sd3 sd4 sd5 sd7 sd8 sd10 sd16 sd17 sd23 sd24 sd25 sd28 sd29 sd41 
srev2 srev3 rev4 srev5 srev7 rev8 srev10 srev16 srev17 srev23 srev24 srev25 srev28 srev29 srev41 
svdc2 svdc3 svdc4 svdc5 svdc7 svdc8 svdc10 svdc16 svdc17 svdc23 svdc24 svdc25 svdc28 svdc29 svdc41 
sndc2 sndc3 sndc4 sndc5 sndc7 sndc8 sndc10 sndc16 sndc17 sndc23 sndc24 sndc25 sndc28 sndc29 sndc41 
snondcost svardcost srevenue sbusdelv sposbus sposres srcat sresdelv swgt 
sdelvcost sprofit stotcost sposstops stotdelv sposdelv sstops svolume 
sfxddcost ssvariblty;

title 'Means and Sums of CS7 Variables Larrys Version';
run;

proc print data = totals;
run;


/*A1 - A56 are the keys for Other Letters, 
B1 - B56 are the keys for Flats, and 
E1 - E56 are the keys for Small Parcels, 
F1 - F56 are the keys for Large Parcels, and 
X1 - X56 are the keys for DPS Letters.  
The numbers 1 - 56 are descriptions for each of the numbered fields.   
Buckets 43 through 54 and 56, Extra Services are included in A only.  
For descriptions of Buckets 1 - 56, see Bucket Descriptions Layout 004.*/
